/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.util;

import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;

public record PortalLocalXY(double localX, double localY) {
    public static PortalLocalXY fromPos(Portal portal, Vec3 pos) {
        Vec3 delta = pos.m_82546_(portal.getOriginPos());
        return PortalLocalXY.fromOffset(portal, delta);
    }

    public static PortalLocalXY fromPos(UnilateralPortalState state, Vec3 pos) {
        Vec3 delta = pos.m_82546_(state.position());
        return PortalLocalXY.fromOffset(state, delta);
    }

    public static PortalLocalXY fromOffset(Portal portal, Vec3 offset) {
        return new PortalLocalXY(portal.axisW.m_82526_(offset), portal.axisH.m_82526_(offset));
    }

    public static PortalLocalXY fromOffset(UnilateralPortalState state, Vec3 offset) {
        Vec3 result = state.orientation().getConjugated().rotate(offset);
        return new PortalLocalXY(result.f_82479_, result.f_82480_);
    }

    public Vec3 getOffset(Portal portal) {
        return portal.axisW.m_82490_(this.localX).m_82549_(portal.axisH.m_82490_(this.localY));
    }

    public Vec3 getOffset(UnilateralPortalState state) {
        return state.orientation().rotate(new Vec3(this.localX, this.localY, 0.0));
    }

    public Vec3 getPos(Portal portal) {
        return portal.getOriginPos().m_82549_(this.getOffset(portal));
    }

    public Vec3 getPos(UnilateralPortalState state) {
        return state.position().m_82549_(this.getOffset(state));
    }
}

